/*
 * TimeTrackController.h
 *
 *  Created on: 03.02.2010
 *      Author: stefan.detter
 */

#ifndef TIMETRACKCONTROLLER_H_
#define TIMETRACKCONTROLLER_H_

#include "../TagReadHandlerBase.h"

#include <QMap>
#include <QTime>

class QFile;

class TimeTrackController : public TagReadHandlerBase
{
	Q_OBJECT

public:
	TimeTrackController(QWidget* mainWidget, Application* manager, QObject* parent = 0);
	virtual ~TimeTrackController();

public slots:
	void doTracking ( bool on );

	virtual void tagEvent(const TagEvent& event);

private:
	QString 							m_lastRecordPath;
	QFile*								m_trackingFile;

	int 					m_rssiDefSize;
	int 					m_memoryDefSize;
	int 					m_triggerDefSize;
	int 					m_antennaDefSize;
	int 					m_frequencyDefSize;
	int 					m_stateDefSize;
	int 					m_batteryDefSize;

	QList<uint>				m_infoPosition;


//	QMap<QString, QMap<uint, uchar> > 	m_history;
//	QTime								m_startTime;
};

#endif /* TIMETRACKCONTROLLER_H_ */
